 param (
    [switch]$quiet = $false
 )
$Host.UI.RawUI.FlushInputBuffer()
if (-Not $quiet) {
    Write-Output 'The setup will prepare your computer for use with the oneclick™ Gateway feature. Please wait a moment. You will receive a notification once the setup is complete.'
}
Set-Location -Path 'Registry::HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control' > $null
Get-Item -Path 'Registry::HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control' | New-Item -Name 'Lsa\MSV1_0' -ErrorAction SilentlyContinue > $null
New-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0' -Name 'RestrictReceivingNTLMTraffic' -Value 0 -PropertyType DWord -Force > $null
New-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0' -Name 'RestrictSendingNTLMTraffic' -Value 0 -PropertyType DWord -Force > $null
Pop-Location > $null
gpupdate /force > $null
if (-Not $quiet) {
    Write-Output 'Setup has been completed successfully. You can now use oneclick™ Gateway.'
}
$Host.UI.RawUI.FlushInputBuffer()
